<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use Symfony\Component\Routing\Annotation\Route;

use App\Entity\TTransactionsAccounts;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Encoder\JsonEncoder;

use App\Repository\TTransactionsAccountsRepository;

class CustomedController extends AbstractController
{
    #[Route('/customed', name: 'customed')]
    public function index(): Response
    {
        return $this->render('customed/index.html.twig', [
            'controller_name' => 'CustomedController',
        ]);

    }

     /**
     * Get users list
     * @param Request $request
     * @Route("/transactionsbyyearbytransactiontype", methods={"GET","POST"})
     * @return Response
     */
    public function transactionsbyyearbytransactiontype(Request $request): Response
    {
        $content = json_decode($request->getContent(), true);

        $myCoaCode1 = $content['coaCode1'];
        $myCoaCode2 = $content['coaCode2'];

        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.transactionDocDate AS transactionDocDate, u.grandTotal AS grandTotal 
                                                  FROM App\Entity\TTransactionsAccounts u 
                                                 WHERE (u.coaCode = '" . $myCoaCode1 . "' OR u.coaCode = '" . $myCoaCode2 . "')");

        $myData = $queryG->getScalarResult();
        
        return new JsonResponse($myData);

    }

     /**
     * Get users list
     * @param Request $request
     * @Route("/salestransactions", methods={"GET","POST"})
     * @return Response
     */
    public function salestransactions(Request $request): Response
    {
        $content = json_decode($request->getContent(), true);

        $myCoaCode1 = $content['coaCode1'];
        $myCoaCode2 = $content['coaCode2'];

        $myTransactionType1 = $content['transactionType1'];
        $myTransactionType2 = $content['transactionType2'];
        
        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.transactionDocDate AS transactionDocDate, u.grandTotal AS grandTotal 
                                                  FROM App\Entity\TTransactionsAccounts u 
                                                 WHERE (u.coaCode = '" . $myCoaCode1 . "' OR u.coaCode = '" . $myCoaCode2 . "')
                                                   AND (u.transactionType = '" . $myTransactionType1 . "' OR u.transactionType = '" . $myTransactionType2 . "')");

        $myData = $queryG->getScalarResult();
        
        return new JsonResponse($myData);

    }

    
}
