<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use App\Repository\TAccountsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *      normalizationContext={"groups"={"t_accounts:read"}, "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_accounts:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "coaCode": "exact", "accountType": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAccountsRepository::class)
 */

class TAccounts
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_accounts:read", "t_transactions_temps_nos:read", "t_transactions_accounts:read", "t_transactions_details:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_transactions_accounts:read", "t_accounts:write", "t_transactions_temps_nos:read"})
     */
    private $coaCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_transactions_accounts:read", "t_accounts:write", "t_transactions_temps_nos:read"})
     */
    private $accountType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountImage;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_transactions_accounts:read", "t_accounts:write", "t_transactions_temps_nos:read"})
     */
    private $accountName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_accounts:write", "t_transactions_temps_nos:read"})
     */
    private $accountPhone1;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_accounts:write", "t_transactions_temps_nos:read"})
     */
    private $accountPhone2;

    /**
     * @ORM\Column(type="string", length=120, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_accounts:read", "t_transactions_temps_nos:read"})
     */
    private $accountPhysicalAdd;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_accounts:write", "t_transactions_temps_nos:read"})
     */
    private $accountEmailAdd;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $contactPerson;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountBankName;

    /**
     * @ORM\Column(type="string", length=120, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountBankAccountBranch;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountBankAccountName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountBankAccountNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $accountStatus;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $defaultAccount;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $lastModifiedOn;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts:read", "t_accounts:write", "t_transactions_details:write", "t_transactions_details:read", "t_transactions_temps_nos:read"})
     */
    private $status;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $note;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_accounts:read", "t_accounts:write", "t_transactions_details:write", "t_transactions_details:read", "t_transactions_temps_nos:read"})
     */
    private $balance;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="account")
     */
    private $details;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsAccounts::class, mappedBy="account")
     */
    private $transactionsAccounts;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $account_system_no;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsAccounts::class, mappedBy="account2")
     * @Groups({"t_accounts:read"})
     */
    private $transactionaccounts2;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $cost;

    /**
     * @ORM\ManyToOne(targetEntity=TChartOfAccounts::class, inversedBy="tAccounts")
     * @Groups({ "t_accounts:read", "t_accounts:write" })
     */
    private $coa;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsCashier::class, mappedBy="account")
     */
    private $tTransactionsCashiers;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsTempsMains::class, mappedBy="account")
     */
    private $tTransactionsTempsMains;

    public function __construct()
    {
        $this->details = new ArrayCollection();
        $this->transactionsAccounts = new ArrayCollection();
        $this->transactionaccounts2 = new ArrayCollection();
        $this->tTransactionsCashiers = new ArrayCollection();
        $this->tTransactionsTempsMains = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoaCode(): ?string
    {
        return $this->coaCode;
    }

    public function setCoaCode(string $coaCode): self
    {
        $this->coaCode = $coaCode;

        return $this;
    }

    public function getAccountType(): ?string
    {
        return $this->accountType;
    }

    public function setAccountType(?string $accountType): self
    {
        $this->accountType = $accountType;

        return $this;
    }

    public function getAccountCode(): ?string
    {
        return $this->accountCode;
    }

    public function setAccountCode(?string $accountCode): self
    {
        $this->accountCode = $accountCode;

        return $this;
    }

    public function getAccountImage(): ?string
    {
        return $this->accountImage;
    }

    public function setAccountImage(?string $accountImage): self
    {
        $this->accountImage = $accountImage;

        return $this;
    }

    public function getAccountName(): ?string
    {
        return $this->accountName;
    }

    public function setAccountName(?string $accountName): self
    {
        $this->accountName = $accountName;

        return $this;
    }

    public function getAccountPhone1(): ?string
    {
        return $this->accountPhone1;
    }

    public function setAccountPhone1(?string $accountPhone1): self
    {
        $this->accountPhone1 = $accountPhone1;

        return $this;
    }

    public function getAccountPhone2(): ?string
    {
        return $this->accountPhone2;
    }

    public function setAccountPhone2(?string $accountPhone2): self
    {
        $this->accountPhone2 = $accountPhone2;

        return $this;
    }

    public function getAccountPhysicalAdd(): ?string
    {
        return $this->accountPhysicalAdd;
    }

    public function setAccountPhysicalAdd(?string $accountPhysicalAdd): self
    {
        $this->accountPhysicalAdd = $accountPhysicalAdd;

        return $this;
    }

    public function getAccountEmailAdd(): ?string
    {
        return $this->accountEmailAdd;
    }

    public function setAccountEmailAdd(?string $accountEmailAdd): self
    {
        $this->accountEmailAdd = $accountEmailAdd;

        return $this;
    }

    public function getContactPerson(): ?string
    {
        return $this->contactPerson;
    }

    public function setContactPerson(?string $contactPerson): self
    {
        $this->contactPerson = $contactPerson;

        return $this;
    }

    public function getAccountBankName(): ?string
    {
        return $this->accountBankName;
    }

    public function setAccountBankName(?string $accountBankName): self
    {
        $this->accountBankName = $accountBankName;

        return $this;
    }

    public function getAccountBankAccountBranch(): ?string
    {
        return $this->accountBankAccountBranch;
    }

    public function setAccountBankAccountBranch(?string $accountBankAccountBranch): self
    {
        $this->accountBankAccountBranch = $accountBankAccountBranch;

        return $this;
    }

    public function getAccountBankAccountName(): ?string
    {
        return $this->accountBankAccountName;
    }

    public function setAccountBankAccountName(?string $accountBankAccountName): self
    {
        $this->accountBankAccountName = $accountBankAccountName;

        return $this;
    }

    public function getAccountBankAccountNo(): ?string
    {
        return $this->accountBankAccountNo;
    }

    public function setAccountBankAccountNo(?string $accountBankAccountNo): self
    {
        $this->accountBankAccountNo = $accountBankAccountNo;

        return $this;
    }

    public function getAccountStatus(): ?string
    {
        return $this->accountStatus;
    }

    public function setAccountStatus(?string $accountStatus): self
    {
        $this->accountStatus = $accountStatus;

        return $this;
    }

    public function getDefaultAccount(): ?string
    {
        return $this->defaultAccount;
    }

    public function setDefaultAccount(?string $defaultAccount): self
    {
        $this->defaultAccount = $defaultAccount;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $balance): self
    {
        $this->balance = $balance;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getDetails(): Collection
    {
        return $this->details;
    }

    public function addDetail(TTransactionsDetails $detail): self
    {
        if (!$this->details->contains($detail)) {
            $this->details[] = $detail;
            $detail->setTAccounts($this);
        }

        return $this;
    }

    public function removeDetail(TTransactionsDetails $detail): self
    {
        if ($this->details->removeElement($detail)) {
            // set the owning side to null (unless already changed)
            if ($detail->getTAccounts() === $this) {
                $detail->setTAccounts(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsAccounts[]
     */
    public function getTransactionsAccounts(): Collection
    {
        return $this->transactionsAccounts;
    }

    public function addTransactionsAccount(TTransactionsAccounts $transactionsAccount): self
    {
        if (!$this->transactionsAccounts->contains($transactionsAccount)) {
            $this->transactionsAccounts[] = $transactionsAccount;
            $transactionsAccount->setAccount($this);
        }

        return $this;
    }

    public function removeTransactionsAccount(TTransactionsAccounts $transactionsAccount): self
    {
        if ($this->transactionsAccounts->removeElement($transactionsAccount)) {
            // set the owning side to null (unless already changed)
            if ($transactionsAccount->getAccount() === $this) {
                $transactionsAccount->setAccount(null);
            }
        }

        return $this;
    }

    public function getAccountSystemNo(): ?string
    {
        return $this->account_system_no;
    }

    public function setAccountSystemNo(?string $account_system_no): self
    {
        $this->account_system_no = $account_system_no;

        return $this;
    }

    /**
     * @return Collection|TTransactionsAccounts[]
     */
    public function getTransactionaccounts2(): Collection
    {
        return $this->transactionaccounts2;
    }

    public function addTransactionaccounts2(TTransactionsAccounts $transactionaccounts2): self
    {
        if (!$this->transactionaccounts2->contains($transactionaccounts2)) {
            $this->transactionaccounts2[] = $transactionaccounts2;
            $transactionaccounts2->setAccount2($this);
        }

        return $this;
    }

    public function removeTransactionaccounts2(TTransactionsAccounts $transactionaccounts2): self
    {
        if ($this->transactionaccounts2->removeElement($transactionaccounts2)) {
            // set the owning side to null (unless already changed)
            if ($transactionaccounts2->getAccount2() === $this) {
                $transactionaccounts2->setAccount2(null);
            }
        }

        return $this;
    }

    /**
     *  @Groups({"t_accounts:read"})
     */
    public function getTotalBalance(){
        $totalBal = 0;
        foreach($this->getTransactionaccounts2() as $account2){
            //if($account2->getAccount2() > 0){
                $totalBal += $account2->getBalance();
            //}
        }
        return $totalBal;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getCoa(): ?TChartOfAccounts
    {
        return $this->coa;
    }

    public function setCoa(?TChartOfAccounts $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    /**
     * @return Collection|TTransactionsCashier[]
     */
    public function getTTransactionsCashiers(): Collection
    {
        return $this->tTransactionsCashiers;
    }

    public function addTTransactionsCashier(TTransactionsCashier $tTransactionsCashier): self
    {
        if (!$this->tTransactionsCashiers->contains($tTransactionsCashier)) {
            $this->tTransactionsCashiers[] = $tTransactionsCashier;
            $tTransactionsCashier->setAccount($this);
        }

        return $this;
    }

    public function removeTTransactionsCashier(TTransactionsCashier $tTransactionsCashier): self
    {
        if ($this->tTransactionsCashiers->removeElement($tTransactionsCashier)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsCashier->getAccount() === $this) {
                $tTransactionsCashier->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsTempsMains[]
     */
    public function getTTransactionsTempsMains(): Collection
    {
        return $this->tTransactionsTempsMains;
    }

    public function addTTransactionsTempsMain(TTransactionsTempsMains $tTransactionsTempsMain): self
    {
        if (!$this->tTransactionsTempsMains->contains($tTransactionsTempsMain)) {
            $this->tTransactionsTempsMains[] = $tTransactionsTempsMain;
            $tTransactionsTempsMain->setAccount($this);
        }

        return $this;
    }

    public function removeTTransactionsTempsMain(TTransactionsTempsMains $tTransactionsTempsMain): self
    {
        if ($this->tTransactionsTempsMains->removeElement($tTransactionsTempsMain)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsTempsMain->getAccount() === $this) {
                $tTransactionsTempsMain->setAccount(null);
            }
        }

        return $this;
    }


}
