<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use App\Repository\TChartOfAccountsRepository;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TInventoryCategoryRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Symfony\Component\Serializer\Annotation\Groups;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_chart_of_accounts:read"}, "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_chart_of_accounts:write"}, "swagger_definition_name"="Write"}
 * )
 * @ORM\Entity(repositoryClass=TChartOfAccountsRepository::class)
 * @ApiFilter(SearchFilter::class, properties={ "status": "exact" })
 * @ApiFilter(OrderFilter::class, properties={ "coaCode": "DESC" })
 */

class TChartOfAccounts
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_chart_of_accounts:read", "t_chart_of_accounts:write", "t_accounts:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_chart_of_accounts:read", "t_chart_of_accounts:write", "t_accounts:read" })
     */
    private $coaCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_chart_of_accounts:read", "t_chart_of_accounts:write", "t_accounts:read" })
     */
    private $coaName;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({ "t_chart_of_accounts:read", "t_chart_of_accounts:write" })
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_chart_of_accounts:read", "t_chart_of_accounts:write" })
     */
    private $lastModifiedOn;

    /**
     * @ORM\ManyToOne(targetEntity=TChartOfAccountsCategories::class, inversedBy="tChartOfAccounts")
     * @Groups({ "t_chart_of_accounts:read", "t_chart_of_accounts:write" })
     */
    private $coaCat;

    /**
     * @ORM\OneToMany(targetEntity=TAccounts::class, mappedBy="coa")
     */
    private $tAccounts;

    public function __construct()
    {
        $this->tAccounts = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoaCode(): ?string
    {
        return $this->coaCode;
    }

    public function setCoaCode(?string $coaCode): self
    {
        $this->coaCode = $coaCode;

        return $this;
    }

    public function getCoaName(): ?string
    {
        return $this->coaName;
    }

    public function setCoaName(?string $coaName): self
    {
        $this->coaName = $coaName;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getCoaCat(): ?TChartOfAccountsCategories
    {
        return $this->coaCat;
    }

    public function setCoaCat(?TChartOfAccountsCategories $coaCat): self
    {
        $this->coaCat = $coaCat;

        return $this;
    }

    /**
     * @return Collection|TAccounts[]
     */
    public function getTAccounts(): Collection
    {
        return $this->tAccounts;
    }

    public function addTAccount(TAccounts $tAccount): self
    {
        if (!$this->tAccounts->contains($tAccount)) {
            $this->tAccounts[] = $tAccount;
            $tAccount->setCoa($this);
        }

        return $this;
    }

    public function removeTAccount(TAccounts $tAccount): self
    {
        if ($this->tAccounts->removeElement($tAccount)) {
            // set the owning side to null (unless already changed)
            if ($tAccount->getCoa() === $this) {
                $tAccount->setCoa(null);
            }
        }

        return $this;
    }

}
