<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TChartOfAccountsCategoriesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Symfony\Component\Serializer\Annotation\Groups;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;

 /**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_chart_of_accounts_categories:read"}, "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_chart_of_accounts_categories:write"}, "swagger_definition_name"="Write"}
 * )
 * @ORM\Entity(repositoryClass=TChartOfAccountsCategoriesRepository::class)
 * @ApiFilter(SearchFilter::class, properties={ "status": "exact" })
 * @ApiFilter(OrderFilter::class, properties={ "catName": "DESC" })
 */

class TChartOfAccountsCategories
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write", "t_chart_of_accounts:read" })
     */
    private $coaCatCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write", "t_chart_of_accounts:read" })
     */
    private $coaCatName;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write" })
     */
    private $coaMin;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write" })
     */
    private $coaMax;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write" })
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write" })
     */
    private $lastModifiedOn;

    /**
     * @ORM\OneToMany(targetEntity=TChartOfAccounts::class, mappedBy="coaCat")
     * @Groups({ "t_chart_of_accounts_categories:read", "t_chart_of_accounts_categories:write" })
     */
    private $tChartOfAccounts;

    public function __construct()
    {
        $this->tChartOfAccounts = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoaCatCode(): ?string
    {
        return $this->coaCatCode;
    }

    public function setCoaCatCode(?string $coaCatCode): self
    {
        $this->coaCatCode = $coaCatCode;

        return $this;
    }

    public function getCoaCatName(): ?string
    {
        return $this->coaCatName;
    }

    public function setCoaCatName(?string $coaCatName): self
    {
        $this->coaCatName = $coaCatName;

        return $this;
    }

    public function getCoaMin(): ?int
    {
        return $this->coaMin;
    }

    public function setCoaMin(?int $coaMin): self
    {
        $this->coaMin = $coaMin;

        return $this;
    }

    public function getCoaMax(): ?int
    {
        return $this->coaMax;
    }

    public function setCoaMax(?int $coaMax): self
    {
        $this->coaMax = $coaMax;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    /**
     * @return Collection|TChartOfAccounts[]
     */
    public function getTChartOfAccounts(): Collection
    {
        return $this->tChartOfAccounts;
    }

    public function addTChartOfAccount(TChartOfAccounts $tChartOfAccount): self
    {
        if (!$this->tChartOfAccounts->contains($tChartOfAccount)) {
            $this->tChartOfAccounts[] = $tChartOfAccount;
            $tChartOfAccount->setCoaCat($this);
        }

        return $this;
    }

    public function removeTChartOfAccount(TChartOfAccounts $tChartOfAccount): self
    {
        if ($this->tChartOfAccounts->removeElement($tChartOfAccount)) {
            // set the owning side to null (unless already changed)
            if ($tChartOfAccount->getCoaCat() === $this) {
                $tChartOfAccount->setCoaCat(null);
            }
        }

        return $this;
    }
}
