<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCheckPaymentsRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ApiResource()
 * @ORM\Entity(repositoryClass=TCheckPaymentsRepository::class)
 */
class TCheckPayments
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $accountId;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $checkNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $drawnDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $maturityDate;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAccountId(): ?int
    {
        return $this->accountId;
    }

    public function setAccountId(?int $accountId): self
    {
        $this->accountId = $accountId;

        return $this;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getCheckNo(): ?string
    {
        return $this->checkNo;
    }

    public function setCheckNo(?string $checkNo): self
    {
        $this->checkNo = $checkNo;

        return $this;
    }

    public function getDrawnDate(): ?\DateTimeInterface
    {
        return $this->drawnDate;
    }

    public function setDrawnDate(?\DateTimeInterface $drawnDate): self
    {
        $this->drawnDate = $drawnDate;

        return $this;
    }

    public function getMaturityDate(): ?\DateTimeInterface
    {
        return $this->maturityDate;
    }

    public function setMaturityDate(?\DateTimeInterface $maturityDate): self
    {
        $this->maturityDate = $maturityDate;

        return $this;
    }
}
