<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TGroupsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_groups:read"}, "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_groups:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TGroupsRepository::class)
 */
class TGroups
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "User:read", "t_groups:read", "t_groups:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $groupName;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $dashboards;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $dashboardPeriodic;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $inventories;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $stockCategories;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $stockInventory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $newStockTake;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $newStockWithdrawals;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $inventoryHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $purchases;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $newSuppliersPurchases;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $suppliersCreditNotes;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $purchasesHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $cashsales;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $newCashsales;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $salesReturns;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $cashsalesHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $creditsales;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $newCreditsales;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $clientCreditNote;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $creditsalesHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $cashier;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $financials;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $accountLedgers;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $cashbookLedgers;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $reports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $inventoryReportsList;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $outofstockItemsReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $purchasesDetailsReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $cashsalesDetailsReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $suppliersListReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $payablesReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $suppliersStatementsReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $clientsListReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $receivablesReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $clientsStatementsReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $dailyReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $monthlyReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $incomeStatementReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $backOffice;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $coaCategories;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $coaSubCategories;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $coaItems;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $cashSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $bankSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $suppliersSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $clientsSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $expensesSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $systemUserSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $accessGroupsSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $userAuthorization;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $companyDetails;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $personalize;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $expenses;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $newExpenses;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $expensesCreditnote;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $expensesHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $stockUnderReOrderLevelReport;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $stockAdjustments;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $status;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $stockPrices;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $inventoryReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $fastMovingItems;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $mostProfitableItems;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $mostStockedItems;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $highestStockItems;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $supplierReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $clientsReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $financialReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $coaSetups;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $accountsSetup;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $security;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $settings;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write", "User:read" })
     */
    private $viewItemCost;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getGroupName(): ?string
    {
        return $this->groupName;
    }

    public function setGroupName(string $groupName): self
    {
        $this->groupName = $groupName;

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getuser(): Collection
    {
        return $this->user;
    }

    public function adduser(User $user): self
    {
        if (!$this->user->contains($user)) {
            $this->user[] = $user;
            $user->setuser($this);
        }

        return $this;
    }

    public function removeuser(User $user): self
    {
        if ($this->user->removeElement($user)) {
            // set the owning side to null (unless already changed)
            if ($user->getuser() === $this) {
                $user->setuser(null);
            }
        }

        return $this;
    }

    public function getDashboards(): ?string
    {
        return $this->dashboards;
    }

    public function setDashboards(?string $dashboards): self
    {
        $this->dashboards = $dashboards;

        return $this;
    }

    public function getDashboardPeriodic(): ?string
    {
        return $this->dashboardPeriodic;
    }

    public function setDashboardPeriodic(?string $dashboardPeriodic): self
    {
        $this->dashboardPeriodic = $dashboardPeriodic;

        return $this;
    }

    public function getInventories(): ?string
    {
        return $this->inventories;
    }

    public function setInventories(?string $inventories): self
    {
        $this->inventories = $inventories;

        return $this;
    }

    public function getStockCategories(): ?string
    {
        return $this->stockCategories;
    }

    public function setStockCategories(?string $stockCategories): self
    {
        $this->stockCategories = $stockCategories;

        return $this;
    }

    public function getStockInventory(): ?string
    {
        return $this->stockInventory;
    }

    public function setStockInventory(?string $stockInventory): self
    {
        $this->stockInventory = $stockInventory;

        return $this;
    }

    public function getNewStockTake(): ?string
    {
        return $this->newStockTake;
    }

    public function setNewStockTake(?string $newStockTake): self
    {
        $this->newStockTake = $newStockTake;

        return $this;
    }

    public function getNewStockWithdrawals(): ?string
    {
        return $this->newStockWithdrawals;
    }

    public function setNewStockWithdrawals(?string $newStockWithdrawals): self
    {
        $this->newStockWithdrawals = $newStockWithdrawals;

        return $this;
    }

    public function getInventoryHistory(): ?string
    {
        return $this->inventoryHistory;
    }

    public function setInventoryHistory(?string $inventoryHistory): self
    {
        $this->inventoryHistory = $inventoryHistory;

        return $this;
    }

    public function getPurchases(): ?string
    {
        return $this->purchases;
    }

    public function setPurchases(?string $purchases): self
    {
        $this->purchases = $purchases;

        return $this;
    }

    public function getNewSuppliersPurchases(): ?string
    {
        return $this->newSuppliersPurchases;
    }

    public function setNewSuppliersPurchases(?string $newSuppliersPurchases): self
    {
        $this->newSuppliersPurchases = $newSuppliersPurchases;

        return $this;
    }

    public function getSuppliersCreditNotes(): ?string
    {
        return $this->suppliersCreditNotes;
    }

    public function setSuppliersCreditNotes(?string $suppliersCreditNotes): self
    {
        $this->suppliersCreditNotes = $suppliersCreditNotes;

        return $this;
    }

    public function getPurchasesHistory(): ?string
    {
        return $this->purchasesHistory;
    }

    public function setPurchasesHistory(?string $purchasesHistory): self
    {
        $this->purchasesHistory = $purchasesHistory;

        return $this;
    }

    public function getCashsales(): ?string
    {
        return $this->cashsales;
    }

    public function setCashsales(?string $cashsales): self
    {
        $this->cashsales = $cashsales;

        return $this;
    }

    public function getNewCashsales(): ?string
    {
        return $this->newCashsales;
    }

    public function setNewCashsales(?string $newCashsales): self
    {
        $this->newCashsales = $newCashsales;

        return $this;
    }

    public function getSalesReturns(): ?string
    {
        return $this->salesReturns;
    }

    public function setSalesReturns(?string $salesReturns): self
    {
        $this->salesReturns = $salesReturns;

        return $this;
    }

    public function getCashsalesHistory(): ?string
    {
        return $this->cashsalesHistory;
    }

    public function setCashsalesHistory(?string $cashsalesHistory): self
    {
        $this->cashsalesHistory = $cashsalesHistory;

        return $this;
    }

    public function getCreditsales(): ?string
    {
        return $this->creditsales;
    }

    public function setCreditsales(?string $creditsales): self
    {
        $this->creditsales = $creditsales;

        return $this;
    }

    public function getNewCreditsales(): ?string
    {
        return $this->newCreditsales;
    }

    public function setNewCreditsales(?string $newCreditsales): self
    {
        $this->newCreditsales = $newCreditsales;

        return $this;
    }

    public function getClientCreditNote(): ?string
    {
        return $this->clientCreditNote;
    }

    public function setClientCreditNote(?string $clientCreditNote): self
    {
        $this->clientCreditNote = $clientCreditNote;

        return $this;
    }

    public function getCreditsalesHistory(): ?string
    {
        return $this->creditsalesHistory;
    }

    public function setCreditsalesHistory(?string $creditsalesHistory): self
    {
        $this->creditsalesHistory = $creditsalesHistory;

        return $this;
    }

    public function getCashier(): ?string
    {
        return $this->cashier;
    }

    public function setCashier(?string $cashier): self
    {
        $this->cashier = $cashier;

        return $this;
    }

    public function getFinancials(): ?string
    {
        return $this->financials;
    }

    public function setFinancials(?string $financials): self
    {
        $this->financials = $financials;

        return $this;
    }

    public function getAccountLedgers(): ?string
    {
        return $this->accountLedgers;
    }

    public function setAccountLedgers(?string $accountLedgers): self
    {
        $this->accountLedgers = $accountLedgers;

        return $this;
    }

    public function getCashbookLedgers(): ?string
    {
        return $this->cashbookLedgers;
    }

    public function setCashbookLedgers(?string $cashbookLedgers): self
    {
        $this->cashbookLedgers = $cashbookLedgers;

        return $this;
    }

    public function getReports(): ?string
    {
        return $this->reports;
    }

    public function setReports(?string $reports): self
    {
        $this->reports = $reports;

        return $this;
    }

    public function getInventoryReportsList(): ?string
    {
        return $this->inventoryReportsList;
    }

    public function setInventoryReportsList(?string $inventoryReportsList): self
    {
        $this->inventoryReportsList = $inventoryReportsList;

        return $this;
    }

    public function getOutofstockItemsReports(): ?string
    {
        return $this->outofstockItemsReports;
    }

    public function setOutofstockItemsReports(?string $outofstockItemsReports): self
    {
        $this->outofstockItemsReports = $outofstockItemsReports;

        return $this;
    }

    public function getPurchasesDetailsReport(): ?string
    {
        return $this->purchasesDetailsReport;
    }

    public function setPurchasesDetailsReport(?string $purchasesDetailsReport): self
    {
        $this->purchasesDetailsReport = $purchasesDetailsReport;

        return $this;
    }

    public function getCashsalesDetailsReport(): ?string
    {
        return $this->cashsalesDetailsReport;
    }

    public function setCashsalesDetailsReport(?string $cashsalesDetailsReport): self
    {
        $this->cashsalesDetailsReport = $cashsalesDetailsReport;

        return $this;
    }

    public function getSuppliersListReport(): ?string
    {
        return $this->suppliersListReport;
    }

    public function setSuppliersListReport(?string $suppliersListReport): self
    {
        $this->suppliersListReport = $suppliersListReport;

        return $this;
    }

    public function getPayablesReport(): ?string
    {
        return $this->payablesReport;
    }

    public function setPayablesReport(string $payablesReport): self
    {
        $this->payablesReport = $payablesReport;

        return $this;
    }

    public function getSuppliersStatementsReport(): ?string
    {
        return $this->suppliersStatementsReport;
    }

    public function setSuppliersStatementsReport(?string $suppliersStatementsReport): self
    {
        $this->suppliersStatementsReport = $suppliersStatementsReport;

        return $this;
    }

    public function getClientsListReport(): ?string
    {
        return $this->clientsListReport;
    }

    public function setClientsListReport(?string $clientsListReport): self
    {
        $this->clientsListReport = $clientsListReport;

        return $this;
    }

    public function getReceivablesReport(): ?string
    {
        return $this->receivablesReport;
    }

    public function setReceivablesReport(?string $receivablesReport): self
    {
        $this->receivablesReport = $receivablesReport;

        return $this;
    }

    public function getClientsStatementsReport(): ?string
    {
        return $this->clientsStatementsReport;
    }

    public function setClientsStatementsReport(?string $clientsStatementsReport): self
    {
        $this->clientsStatementsReport = $clientsStatementsReport;

        return $this;
    }

    public function getDailyReport(): ?string
    {
        return $this->dailyReport;
    }

    public function setDailyReport(?string $dailyReport): self
    {
        $this->dailyReport = $dailyReport;

        return $this;
    }

    public function getMonthlyReport(): ?string
    {
        return $this->monthlyReport;
    }

    public function setMonthlyReport(?string $monthlyReport): self
    {
        $this->monthlyReport = $monthlyReport;

        return $this;
    }

    public function getIncomeStatementReport(): ?string
    {
        return $this->incomeStatementReport;
    }

    public function setIncomeStatementReport(?string $incomeStatementReport): self
    {
        $this->incomeStatementReport = $incomeStatementReport;

        return $this;
    }

    public function getBackOffice(): ?string
    {
        return $this->backOffice;
    }

    public function setBackOffice(?string $backOffice): self
    {
        $this->backOffice = $backOffice;

        return $this;
    }

    public function getCoaCategories(): ?string
    {
        return $this->coaCategories;
    }

    public function setCoaCategories(?string $coaCategories): self
    {
        $this->coaCategories = $coaCategories;

        return $this;
    }

    public function getCoaSubCategories(): ?string
    {
        return $this->coaSubCategories;
    }

    public function setCoaSubCategories(?string $coaSubCategories): self
    {
        $this->coaSubCategories = $coaSubCategories;

        return $this;
    }

    public function getCoaItems(): ?string
    {
        return $this->coaItems;
    }

    public function setCoaItems(?string $coaItems): self
    {
        $this->coaItems = $coaItems;

        return $this;
    }

    public function getCashSetup(): ?string
    {
        return $this->cashSetup;
    }

    public function setCashSetup(?string $cashSetup): self
    {
        $this->cashSetup = $cashSetup;

        return $this;
    }

    public function getBankSetup(): ?string
    {
        return $this->bankSetup;
    }

    public function setBankSetup(?string $bankSetup): self
    {
        $this->bankSetup = $bankSetup;

        return $this;
    }

    public function getSuppliersSetup(): ?string
    {
        return $this->suppliersSetup;
    }

    public function setSuppliersSetup(?string $suppliersSetup): self
    {
        $this->suppliersSetup = $suppliersSetup;

        return $this;
    }

    public function getClientsSetup(): ?string
    {
        return $this->clientsSetup;
    }

    public function setClientsSetup(?string $clientsSetup): self
    {
        $this->clientsSetup = $clientsSetup;

        return $this;
    }

    public function getExpensesSetup(): ?string
    {
        return $this->expensesSetup;
    }

    public function setExpensesSetup(?string $expensesSetup): self
    {
        $this->expensesSetup = $expensesSetup;

        return $this;
    }

    public function getSystemUserSetup(): ?string
    {
        return $this->systemUserSetup;
    }

    public function setSystemUserSetup(?string $systemUserSetup): self
    {
        $this->systemUserSetup = $systemUserSetup;

        return $this;
    }

    public function getAccessGroupsSetup(): ?string
    {
        return $this->accessGroupsSetup;
    }

    public function setAccessGroupsSetup(?string $accessGroupsSetup): self
    {
        $this->accessGroupsSetup = $accessGroupsSetup;

        return $this;
    }

    public function getUserAuthorization(): ?string
    {
        return $this->userAuthorization;
    }

    public function setUserAuthorization(?string $userAuthorization): self
    {
        $this->userAuthorization = $userAuthorization;

        return $this;
    }

    public function getCompanyDetails(): ?string
    {
        return $this->companyDetails;
    }

    public function setCompanyDetails(?string $companyDetails): self
    {
        $this->companyDetails = $companyDetails;

        return $this;
    }

    public function getPersonalize(): ?string
    {
        return $this->personalize;
    }

    public function setPersonalize(?string $personalize): self
    {
        $this->personalize = $personalize;

        return $this;
    }

    public function getExpenses(): ?string
    {
        return $this->expenses;
    }

    public function setExpenses(?string $expenses): self
    {
        $this->expenses = $expenses;

        return $this;
    }

    public function getNewExpenses(): ?string
    {
        return $this->newExpenses;
    }

    public function setNewExpenses(?string $newExpenses): self
    {
        $this->newExpenses = $newExpenses;

        return $this;
    }

    public function getexpensesCreditnote(): ?string
    {
        return $this->expensesCreditnote;
    }

    public function setexpensesCreditnote(?string $expensesCreditnote): self
    {
        $this->expensesCreditnote = $expensesCreditnote;

        return $this;
    }

    public function getExpensesHistory(): ?string
    {
        return $this->expensesHistory;
    }

    public function setExpensesHistory(?string $expensesHistory): self
    {
        $this->expensesHistory = $expensesHistory;

        return $this;
    }

    public function getStockUnderReOrderLevelReport(): ?string
    {
        return $this->stockUnderReOrderLevelReport;
    }

    public function setStockUnderReOrderLevelReport(?string $stockUnderReOrderLevelReport): self
    {
        $this->stockUnderReOrderLevelReport = $stockUnderReOrderLevelReport;

        return $this;
    }

    public function getStockAdjustments(): ?string
    {
        return $this->stockAdjustments;
    }

    public function setStockAdjustments(?string $stockAdjustments): self
    {
        $this->stockAdjustments = $stockAdjustments;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getStockPrices(): ?string
    {
        return $this->stockPrices;
    }

    public function setStockPrices(?string $stockPrices): self
    {
        $this->stockPrices = $stockPrices;

        return $this;
    }

    public function getInventoryReports(): ?string
    {
        return $this->inventoryReports;
    }

    public function setInventoryReports(?string $inventoryReports): self
    {
        $this->inventoryReports = $inventoryReports;

        return $this;
    }

    public function getFastMovingItems(): ?string
    {
        return $this->fastMovingItems;
    }

    public function setFastMovingItems(?string $fastMovingItems): self
    {
        $this->fastMovingItems = $fastMovingItems;

        return $this;
    }

    public function getMostProfitableItems(): ?string
    {
        return $this->mostProfitableItems;
    }

    public function setMostProfitableItems(?string $mostProfitableItems): self
    {
        $this->mostProfitableItems = $mostProfitableItems;

        return $this;
    }

    public function getMostStockedItems(): ?string
    {
        return $this->mostStockedItems;
    }

    public function setMostStockedItems(?string $mostStockedItems): self
    {
        $this->mostStockedItems = $mostStockedItems;

        return $this;
    }

    public function getHighestStockItems(): ?string
    {
        return $this->highestStockItems;
    }

    public function setHighestStockItems(?string $highestStockItems): self
    {
        $this->highestItockItems = $highestStockItems;

        return $this;
    }

    public function getSupplierReports(): ?string
    {
        return $this->supplierReports;
    }

    public function setSupplierReports(?string $supplierReports): self
    {
        $this->supplierReports = $supplierReports;

        return $this;
    }

    public function getClientsReports(): ?string
    {
        return $this->clientsReports;
    }

    public function setClientsReports(?string $clientsReports): self
    {
        $this->clientsReports = $clientsReports;

        return $this;
    }

    public function getFinancialReports(): ?string
    {
        return $this->financialReports;
    }

    public function setFinancialReports(?string $financialReports): self
    {
        $this->financialReports = $financialReports;

        return $this;
    }

    public function getCoaSetups(): ?string
    {
        return $this->coaSetups;
    }

    public function setCoaSetups(?string $coaSetups): self
    {
        $this->coaSetups = $coaSetups;

        return $this;
    }

    public function getAccountsSetup(): ?string
    {
        return $this->accountsSetup;
    }

    public function setAccountsSetup(?string $accountsSetup): self
    {
        $this->accountsSetup = $accountsSetup;

        return $this;
    }

    public function getSecurity(): ?string
    {
        return $this->security;
    }

    public function setSecurity(?string $security): self
    {
        $this->security = $security;

        return $this;
    }

    public function getSettings(): ?string
    {
        return $this->settings;
    }

    public function setSettings(?string $settings): self
    {
        $this->settings = $settings;

        return $this;
    }

    public function getViewItemCost(): ?string
    {
        return $this->viewItemCost;
    }

    public function setViewItemCost(?string $viewItemCost): self
    {
        $this->viewItemCost = $viewItemCost;

        return $this;
    }
}
