<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TInventoryCategoryRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use App\Repository\TGroupsRepository;
use Symfony\Component\Serializer\Annotation\Groups;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_inventory_category:read"}, "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_inventory_category:write"}, "swagger_definition_name"="Write"}
 * )
 * @ORM\Entity(repositoryClass=TInventoryCategoryRepository::class)
 * @ApiFilter(SearchFilter::class, properties={ "status": "exact" })
 * @ApiFilter(OrderFilter::class, properties={ "catName": "DESC" })
 */
class TInventoryCategory
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_lists:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write", "t_inventory_lists:read" })
     */
    private $catName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $stockCoaCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $stockAdjustCoaCode;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $salesCoaCode;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $costOfSalesCoaCode;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $purchasesTaxCoaCode;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $salesTaxCoaCode;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_inventory_list:read", "t_inventory_category:read", "t_inventory_category:write" })
     */
    private $note;

    /**
     * @ORM\OneToMany(targetEntity=TInventoryList::class, mappedBy="category")
     */
    private $item;

    public function __construct()
    {
        $this->item = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCatName(): ?string
    {
        return $this->catName;
    }

    public function setCatName(?string $catName): self
    {
        $this->catName = $catName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getStockCoaCode(): ?int
    {
        return $this->stockCoaCode;
    }

    public function setStockCoaCode(?int $stockCoaCode): self
    {
        $this->stockCoaCode = $stockCoaCode;

        return $this;
    }

    public function getStockAdjustCoaCode(): ?int
    {
        return $this->stockAdjustCoaCode;
    }

    public function setStockAdjustCoaCode(?int $stockAdjustCoaCode): self
    {
        $this->stockAdjustCoaCode = $stockAdjustCoaCode;

        return $this;
    }

    public function getSalesCoaCode(): ?int
    {
        return $this->salesCoaCode;
    }

    public function setSalesCoaCode(?int $salesCoaCode): self
    {
        $this->salesCoaCode = $salesCoaCode;

        return $this;
    }

    public function getCostOfSalesCoaCode(): ?int
    {
        return $this->costOfSalesCoaCode;
    }

    public function setCostOfSalesCoaCode(?int $costOfSalesCoaCode): self
    {
        $this->costOfSalesCoaCode = $costOfSalesCoaCode;

        return $this;
    }

    public function getPurchasesTaxCoaCode(): ?int
    {
        return $this->purchasesTaxCoaCode;
    }

    public function setPurchasesTaxCoaCode(?int $purchasesTaxCoaCode): self
    {
        $this->purchasesTaxCoaCode = $purchasesTaxCoaCode;

        return $this;
    }

    public function getSalesTaxCoaCode(): ?int
    {
        return $this->salesTaxCoaCode;
    }

    public function setSalesTaxCoaCode(?int $salesTaxCoaCode): self
    {
        $this->salesTaxCoaCode = $salesTaxCoaCode;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    /**
     * @return Collection|TInventoryList[]
     */
    public function getItem(): Collection
    {
        return $this->item;
    }

    public function addItem(TInventoryList $item): self
    {
        if (!$this->item->contains($item)) {
            $this->item[] = $item;
            $item->setCategory($this);
        }

        return $this;
    }

    public function removeItem(TInventoryList $item): self
    {
        if ($this->item->removeElement($item)) {
            // set the owning side to null (unless already changed)
            if ($item->getCategory() === $this) {
                $item->setCategory(null);
            }
        }

        return $this;
    }
}
