<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\RangeFilter;

use App\Repository\TInventoryListRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *     normalizationContext={"groups"={"t_inventory_lists:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_inventory_lists:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(SearchFilter::class, properties={ "itemType": "exact","totalQuantity": "exact", "status": "exact" })
 * @ApiFilter(RangeFilter::class, properties={"itemMoveCount", "quantity"})
 * @ORM\Entity(repositoryClass=TInventoryListRepository::class)
 */

class TInventoryList
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_inventory_lists:read", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_details:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_details:read", "inventory_prices:read"})
     */
    private $itemDescription;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $itemType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $location;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $reOrderLevel;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lastSupId;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lastClientId;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lastModifiedOn;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lockPurchasesPrices;

    /**
     * @ORM\ManyToOne(targetEntity=TInventoryCategory::class, inversedBy="item")
     * @Groups({ "t_inventory_lists:read", "t_inventory_lists:write" })
     */
    private $category;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsTempsDetails::class, mappedBy="item")
     * @Groups({"t_inventory_lists:read"})
     */
    private $tempDetails;

    /**
    * to be created from tempdetails
    *
    * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="item")
    */
    private $details;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $quantity;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lastPurchaseDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $lastSaleDate;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $itemMoveCount;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $note;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $price;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $serialNumber;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $barcode;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $wholesalePrice;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $profitMargin;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $offerPercentage;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $taxPercent;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_inventory_lists:read", "t_inventory_lists:write"})
     */
    private $applyOffer;

    public function __construct()
    {
        $this->details = new ArrayCollection();
        $this->tempDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getItemDescription(): ?string
    {
        return $this->itemDescription;
    }

    public function setItemDescription(?string $itemDescription): self
    {
        $this->itemDescription = $itemDescription;

        return $this;
    }

    public function getItemType(): ?string
    {
        return $this->itemType;
    }

    public function setItemType(?string $itemType): self
    {
        $this->itemType = $itemType;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getLocation(): ?string
    {
        return $this->location;
    }

    public function setLocation(?string $location): self
    {
        $this->location = $location;

        return $this;
    }

    public function getReOrderLevel(): ?int
    {
        return $this->reOrderLevel;
    }

    public function setReOrderLevel(?int $reOrderLevel): self
    {
        $this->reOrderLevel = $reOrderLevel;

        return $this;
    }

    public function getLastSupId(): ?int
    {
        return $this->lastSupId;
    }

    public function setLastSupId(?int $lastSupId): self
    {
        $this->lastSupId = $lastSupId;

        return $this;
    }

    public function getLastClientId(): ?int
    {
        return $this->lastClientId;
    }

    public function setLastClientId(?int $lastClientId): self
    {
        $this->lastClientId = $lastClientId;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getLockPurchasesPrices(): ?string
    {
        return $this->lockPurchasesPrices;
    }

    public function setLockPurchasesPrices(?string $lockPurchasesPrices): self
    {
        $this->lockPurchasesPrices = $lockPurchasesPrices;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getDetails(): Collection
    {
        return $this->details;
    }

    public function addDetail(TTransactionsDetails $detail): self
    {
        if (!$this->details->contains($detail)) {
            $this->details[] = $detail;
            $detail->setItem($this);
        }

        return $this;
    }

    public function removeDetail(TTransactionsDetails $detail): self
    {
        if ($this->details->removeElement($detail)) {
            // set the owning side to null (unless already changed)
            if ($detail->getItem() === $this) {
                $detail->setItem(null);
            }
        }

        return $this;
    }

    /**
     *  @Groups({"t_inventory_lists:read"})
     */
    public function getTotalQuantity(){
        $total = 0;
        foreach($this->getDetails() as $detail){
            $total += $detail->getQty();
        }
        return $total;
    }

    public function getCategory(): ?TInventoryCategory
    {
        return $this->category;
    }

    public function setCategory(?TInventoryCategory $category): self
    {
        $this->category = $category;

        return $this;
    }

    /**
     * @return Collection|TTransactionsTempsDetails[]
     */
    public function getTempDetails(): Collection
    {
        return $this->tempDetails;
    }

    public function addTempdetail(TTransactionsTempsDetails $tempDetail): self
    {
        if (!$this->tempDetails->contains($tempDetail)) {
            $this->tempDetails[] = $tempDetail;
            $tempDetail->setItem($this);
        }

        return $this;
    }

    public function removeTempdetail(TTransactionsTempsDetails $tempDetail): self
    {
        if ($this->tempDetails->removeElement($tempDetail)) {
            // set the owning side to null (unless already changed)
            if ($tempDetail->getItem() === $this) {
                $tempDetail->setItem(null);
            }
        }

        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $quantity): self
    {
        $this->quantity = $quantity;

        return $this;
    }

    public function getLastPurchaseDate(): ?\DateTimeInterface
    {
        return $this->lastPurchaseDate;
    }

    public function setLastPurchaseDate(?\DateTimeInterface $lastPurchaseDate): self
    {
        $this->lastPurchaseDate = $lastPurchaseDate;

        return $this;
    }

    public function getLastSaleDate(): ?\DateTimeInterface
    {
        return $this->lastSaleDate;
    }

    public function setLastSaleDate(?\DateTimeInterface $lastSaleDate): self
    {
        $this->lastSaleDate = $lastSaleDate;

        return $this;
    }

    public function getItemMoveCount(): ?int
    {
        return $this->itemMoveCount;
    }

    public function setItemMoveCount(?int $itemMoveCount): self
    {
        $this->itemMoveCount = $itemMoveCount;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getAuthor(): ?string
    {
        return $this->author;
    }

    public function setAuthor(?string $author): self
    {
        $this->author = $author;

        return $this;
    }

    public function getSerialNumber(): ?string
    {
        return $this->serialNumber;
    }

    public function setSerialNumber(?string $serialNumber): self
    {
        $this->serialNumber = $serialNumber;

        return $this;
    }

    public function getBarcode(): ?string
    {
        return $this->barcode;
    }

    public function setBarcode(?string $barcode): self
    {
        $this->barcode = $barcode;

        return $this;
    }

    public function getWholesalePrice(): ?string
    {
        return $this->wholesalePrice;
    }

    public function setWholesalePrice(?string $wholesalePrice): self
    {
        $this->wholesalePrice = $wholesalePrice;

        return $this;
    }

    public function getProfitMargin(): ?string
    {
        return $this->profitMargin;
    }

    public function setProfitMargin(?string $profitMargin): self
    {
        $this->profitMargin = $profitMargin;

        return $this;
    }

    public function getOfferPercentage(): ?string
    {
        return $this->offerPercentage;
    }

    public function setOfferPercentage(?string $offerPercentage): self
    {
        $this->offerPercentage = $offerPercentage;

        return $this;
    }

    public function getTaxPercent(): ?string
    {
        return $this->taxPercent;
    }

    public function setTaxPercent(?string $taxPercent): self
    {
        $this->taxPercent = $taxPercent;

        return $this;
    }

    public function getApplyOffer(): ?string
    {
        return $this->applyOffer;
    }

    public function setApplyOffer(?string $applyOffer): self
    {
        $this->applyOffer = $applyOffer;

        return $this;
    }

}
