<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStaffMembersRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\RangeFilter;

use App\Repository\TInventoryListRepository;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *     normalizationContext={"groups"={"t_staff_members:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_staff_members:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "status": "exact" })
 * @ORM\Entity(repositoryClass=TStaffMembersRepository::class)
 */

class TStaffMembers
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"User:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $phoneNo1;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $phoneNo2;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $emailAdd;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $phyAdd;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $nextOfKinName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $nextOfKinContact;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "TStaffMembers:read", "TStaffMembers:write", "User:read" })
     */
    private $status;

    public function __construct()
    {
        $this->users = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getPhoneNo1(): ?string
    {
        return $this->phoneNo1;
    }

    public function setPhoneNo1(?string $phoneNo1): self
    {
        $this->phoneNo1 = $phoneNo1;

        return $this;
    }

    public function getPhoneNo2(): ?string
    {
        return $this->phoneNo2;
    }

    public function setPhoneNo2(string $phoneNo2): self
    {
        $this->phoneNo2 = $phoneNo2;

        return $this;
    }

    public function getEmailAdd(): ?string
    {
        return $this->emailAdd;
    }

    public function setEmailAdd(?string $emailAdd): self
    {
        $this->emailAdd = $emailAdd;

        return $this;
    }

    public function getPhyAdd(): ?string
    {
        return $this->phyAdd;
    }

    public function setPhyAdd(?string $phyAdd): self
    {
        $this->phyAdd = $phyAdd;

        return $this;
    }

    public function getNextOfKinName(): ?string
    {
        return $this->nextOfKinName;
    }

    public function setNextOfKinName(?string $nextOfKinName): self
    {
        $this->nextOfKinName = $nextOfKinName;

        return $this;
    }

    public function getNextOfKinContact(): ?string
    {
        return $this->nextOfKinContact;
    }

    public function setNextOfKinContact(?string $nextOfKinContact): self
    {
        $this->nextOfKinContact = $nextOfKinContact;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

}
