<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTransactionsTempsCashierRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ApiResource()
 * @ORM\Entity(repositoryClass=TTransactionsTempsCashierRepository::class)
 */
class TTransactionsTempsCashier
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $transactionType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="time", nullable=true)
     */
    private $transactionSystemTime;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $transactionSystemUser;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $narration;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $drCr;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $accountId;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $transactionDocNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $transactionDocDate;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     */
    private $totalTax;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     */
    private $totalAmount;

    /**
     * @ORM\Column(type="decimal", precision=2, scale=2, nullable=true)
     */
    private $totalDisc;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     */
    private $grandTotal;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     */
    private $balanceChange;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $coaCode;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     */
    private $costOfGoodsSold;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $status;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $sentBy;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $receiverBy;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $lastModifiedOn;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionSystemTime(): ?\DateTimeInterface
    {
        return $this->transactionSystemTime;
    }

    public function setTransactionSystemTime(?\DateTimeInterface $transactionSystemTime): self
    {
        $this->transactionSystemTime = $transactionSystemTime;

        return $this;
    }

    public function getTransactionSystemUser(): ?int
    {
        return $this->transactionSystemUser;
    }

    public function setTransactionSystemUser(?int $transactionSystemUser): self
    {
        $this->transactionSystemUser = $transactionSystemUser;

        return $this;
    }

    public function getNarration(): ?string
    {
        return $this->narration;
    }

    public function setNarration(?string $narration): self
    {
        $this->narration = $narration;

        return $this;
    }

    public function getDrCr(): ?string
    {
        return $this->drCr;
    }

    public function setDrCr(?string $drCr): self
    {
        $this->drCr = $drCr;

        return $this;
    }

    public function getAccountId(): ?int
    {
        return $this->accountId;
    }

    public function setAccountId(?int $accountId): self
    {
        $this->accountId = $accountId;

        return $this;
    }

    public function getTransactionDocNo(): ?string
    {
        return $this->transactionDocNo;
    }

    public function setTransactionDocNo(?string $transactionDocNo): self
    {
        $this->transactionDocNo = $transactionDocNo;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getTotalTax(): ?string
    {
        return $this->totalTax;
    }

    public function setTotalTax(?string $totalTax): self
    {
        $this->totalTax = $totalTax;

        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $totalAmount): self
    {
        $this->totalAmount = $totalAmount;

        return $this;
    }

    public function getTotalDisc(): ?string
    {
        return $this->totalDisc;
    }

    public function setTotalDisc(?string $totalDisc): self
    {
        $this->totalDisc = $totalDisc;

        return $this;
    }

    public function getGrandTotal(): ?string
    {
        return $this->grandTotal;
    }

    public function setGrandTotal(?string $grandTotal): self
    {
        $this->grandTotal = $grandTotal;

        return $this;
    }

    public function getBalanceChange(): ?string
    {
        return $this->balanceChange;
    }

    public function setBalanceChange(?string $balanceChange): self
    {
        $this->balanceChange = $balanceChange;

        return $this;
    }

    public function getCoaCode(): ?string
    {
        return $this->coaCode;
    }

    public function setCoaCode(?string $coaCode): self
    {
        $this->coaCode = $coaCode;

        return $this;
    }

    public function getCostOfGoodsSold(): ?string
    {
        return $this->costOfGoodsSold;
    }

    public function setCostOfGoodsSold(?string $costOfGoodsSold): self
    {
        $this->costOfGoodsSold = $costOfGoodsSold;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getSentBy(): ?int
    {
        return $this->sentBy;
    }

    public function setSentBy(?int $sentBy): self
    {
        $this->sentBy = $sentBy;

        return $this;
    }

    public function getReceiverBy(): ?int
    {
        return $this->receiverBy;
    }

    public function setReceiverBy(?int $receiverBy): self
    {
        $this->receiverBy = $receiverBy;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }
}
