<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;
use App\Repository\TTransactionsTempsDetailsRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

/**
* @ApiResource(
*  normalizationContext={"groups"={"t_transactions_temps_details:read"}, "swagger_definition_name"="Read"},
*  denormalizationContext={"groups"={"t_transactions_temps_details:write"}, "swagger_definition_name"="Write"})
* @ApiFilter(SearchFilter::class, properties={ "transactionTempNoId": "exact" })
* @ApiFilter(OrderFilter::class, properties={ "id": "DESC" })
* @ORM\Entity(repositoryClass=TTransactionsTempsDetailsRepository::class)
*/

class TTransactionsTempsDetails
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_transactions_temps_nos:read", "t_transactions_temps_details:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $coaId;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $qty;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $taxPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $price;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $discPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $discAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $amount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $taxAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $totalCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $profitMargin;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $stockCoaCode;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $salesCoaCode;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $costOfSalesCoaCode;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_nos:write", "t_transactions_temps_nos:read", "t_transactions_temps_details:read", "t_transactions_temps_details:write"})
     */
    private $costOfGoodsSold;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $purchasesTaxCoaCode;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $salesTaxCoaCode;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $lastModifiedOn;

    /**
     * @ORM\ManyToOne(targetEntity=TInventoryList::class, inversedBy="tempDetails")
     * @Groups({"t_transactions_temps_details:read", "t_transactions_temps_details:write", "t_transactions_temps_nos:read", "t_transactions_temps_nos:write"})
     */
    private $item;

    /**
     * @ORM\ManyToOne(targetEntity=TTransactionsTempsMains::class, inversedBy="tTransactionsTempsDetails")
     * @ORM\JoinColumn(nullable=false)
     */
    private $transactionTempNo;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoaId(): ?int
    {
        return $this->coaId;
    }

    public function setCoaId(?int $coaId): self
    {
        $this->coaId = $coaId;

        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $qty): self
    {
        $this->qty = $qty;

        return $this;
    }

    public function getTaxPercent(): ?string
    {
        return $this->taxPercent;
    }

    public function setTaxPercent(?string $taxPercent): self
    {
        $this->taxPercent = $taxPercent;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getDiscPercent(): ?string
    {
        return $this->discPercent;
    }

    public function setDiscPercent(?string $discPercent): self
    {
        $this->discPercent = $discPercent;

        return $this;
    }

    public function getDiscAmount(): ?string
    {
        return $this->discAmount;
    }

    public function setDiscAmount(?string $discAmount): self
    {
        $this->discAmount = $discAmount;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getTaxAmount(): ?string
    {
        return $this->taxAmount;
    }

    public function setTaxAmount(?string $taxAmount): self
    {
        $this->taxAmount = $taxAmount;

        return $this;
    }

    public function getTotalCost(): ?string
    {
        return $this->totalCost;
    }

    public function setTotalCost(?string $totalCost): self
    {
        $this->totalCost = $totalCost;

        return $this;
    }

    public function getProfitMargin(): ?string
    {
        return $this->profitMargin;
    }

    public function setProfitMargin(?string $profitMargin): self
    {
        $this->profitMargin = $profitMargin;

        return $this;
    }

    public function getStockCoaCode(): ?int
    {
        return $this->stockCoaCode;
    }

    public function setStockCoaCode(?int $stockCoaCode): self
    {
        $this->stockCoaCode = $stockCoaCode;

        return $this;
    }

    public function getSalesCoaCode(): ?int
    {
        return $this->salesCoaCode;
    }

    public function setSalesCoaCode(?int $salesCoaCode): self
    {
        $this->salesCoaCode = $salesCoaCode;

        return $this;
    }

    public function getCostOfSalesCoaCode(): ?int
    {
        return $this->costOfSalesCoaCode;
    }

    public function setCostOfSalesCoaCode(?int $costOfSalesCoaCode): self
    {
        $this->costOfSalesCoaCode = $costOfSalesCoaCode;

        return $this;
    }

    public function getCostOfGoodsSold(): ?string
    {
        return $this->costOfGoodsSold;
    }

    public function setCostOfGoodsSold(?string $costOfGoodsSold): self
    {
        $this->costOfGoodsSold = $costOfGoodsSold;

        return $this;
    }

    public function getPurchasesTaxCoaCode(): ?int
    {
        return $this->purchasesTaxCoaCode;
    }

    public function setPurchasesTaxCoaCode(?int $purchasesTaxCoaCode): self
    {
        $this->purchasesTaxCoaCode = $purchasesTaxCoaCode;

        return $this;
    }

    public function getSalesTaxCoaCode(): ?int
    {
        return $this->salesTaxCoaCode;
    }

    public function setSalesTaxCoaCode(?int $salesTaxCoaCode): self
    {
        $this->salesTaxCoaCode = $salesTaxCoaCode;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getItem(): ?TInventoryList
    {
        return $this->item;
    }

    public function setItem(?TInventoryList $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getTransactionTempNo(): ?TTransactionsTempsMains
    {
        return $this->transactionTempNo;
    }

    public function setTransactionTempNo(?TTransactionsTempsMains $transactionTempNo): self
    {
        $this->transactionTempNo = $transactionTempNo;

        return $this;
    }

}
