<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTransactionsTempsMainsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints\DateTime;

 /**
 * @ApiResource(
 *      normalizationContext={"groups"={"t_transactions_temps_mains:read"}, "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_transactions_temps_mains:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "transactionType": "exact", "transactionSystemNo": "exact", "transactionSystemDate": "exact", "transactionDocNo": "exact", "referenceNo": "exact" })
 * @ApiFilter(DateFilter::class, properties={"transactionDocDate"})
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TTransactionsTempsMainsRepository::class)
 */

class TTransactionsTempsMains
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $transactionType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $transactionSystemTime;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $transactionDocDate;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $totalTax;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $totalAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $totalDisc;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $grandTotal;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $costOfGoodsSold;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $status;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $lastModifiedOn;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $referenceNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $referenceDate;

    /**
     * @ORM\ManyToOne(targetEntity=TAccounts::class, inversedBy="tTransactionsTempsMains")
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $account;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsTempsDetails::class, mappedBy="transactionTempNo")
     * @Groups({"t_transactions_temps_mains:read", "t_transactions_temps_mains:write"})
     */
    private $tTransactionsTempsDetails;

    public function __construct()
    {
        $this->tTransactionsTempsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionSystemTime(): ?string
    {
        return $this->transactionSystemTime;
    }

    public function setTransactionSystemTime(?string $transactionSystemTime): self
    {
        $this->transactionSystemTime = $transactionSystemTime;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getTotalTax(): ?string
    {
        return $this->totalTax;
    }

    public function setTotalTax(?string $totalTax): self
    {
        $this->totalTax = $totalTax;

        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $totalAmount): self
    {
        $this->totalAmount = $totalAmount;

        return $this;
    }

    public function getTotalDisc(): ?string
    {
        return $this->totalDisc;
    }

    public function setTotalDisc(?string $totalDisc): self
    {
        $this->totalDisc = $totalDisc;

        return $this;
    }

    public function getGrandTotal(): ?string
    {
        return $this->grandTotal;
    }

    public function setGrandTotal(?string $grandTotal): self
    {
        $this->grandTotal = $grandTotal;

        return $this;
    }

    public function getCostOfGoodsSold(): ?string
    {
        return $this->costOfGoodsSold;
    }

    public function setCostOfGoodsSold(?string $costOfGoodsSold): self
    {
        $this->costOfGoodsSold = $costOfGoodsSold;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getReferenceNo(): ?string
    {
        return $this->referenceNo;
    }

    public function setReferenceNo(?string $referenceNo): self
    {
        $this->referenceNo = $referenceNo;

        return $this;
    }

    public function getReferenceDate(): ?\DateTimeInterface
    {
        return $this->referenceDate;
    }

    public function setReferenceDate(?\DateTimeInterface $referenceDate): self
    {
        $this->referenceDate = $referenceDate;

        return $this;
    }

    public function getAccount(): ?TAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    /**
     * @return Collection|TTransactionsTempsDetails[]
     */
    public function getTTransactionsTempsDetails(): Collection
    {
        return $this->tTransactionsTempsDetails;
    }

    public function addTTransactionsTempsDetail(TTransactionsTempsDetails $tTransactionsTempsDetail): self
    {
        if (!$this->tTransactionsTempsDetails->contains($tTransactionsTempsDetail)) {
            $this->tTransactionsTempsDetails[] = $tTransactionsTempsDetail;
            $tTransactionsTempsDetail->setTransactionTempNo($this);
        }

        return $this;
    }

    public function removeTTransactionsTempsDetail(TTransactionsTempsDetails $tTransactionsTempsDetail): self
    {
        if ($this->tTransactionsTempsDetails->removeElement($tTransactionsTempsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsTempsDetail->getTransactionTempNo() === $this) {
                $tTransactionsTempsDetail->setTransactionTempNo(null);
            }
        }

        return $this;
    }
}
